function u=valutascalareP1(t,y,vertices,elements,bxmin,bymin,bxmax,bymax,uvertex)
%VALUTASCALAREP1 evaluate a P1 function on a set of nodes.
%   VALUES=VALUTASCALAREP1(T,Y,NODES,VERTICES,ELEMENTS,BXMIN,BYMIN,BXMAX,BYMAX,UH)
%   computes the values VALUES of the P1 function UH on the nodes NODES.
%   BXMIN, BYMIN, BXMAX, BYMAX are the extrema of the bounding-boxes of
%   each elements ELEMENTS of the mesh whose vertices are given in VERTICES.
%   The first input parameters T and Y is due to compatibility with the Matlab's
%   ODE solvers.



lxy = length(y)/2;
xfoot = y(1:lxy);
yfoot = y(lxy+1:end);
if(size(vertices,2)~=length(uvertex))
    error('not enough or too much data to interpolate');
end

v=findnodes(vertices,elements,xfoot,yfoot,bxmin,bymin,bxmax,bymax);
for i = 1:lxy %ciclo sui nodi
    element_index = v(i,1); %elemento a cui appartiene il nodo corrente
    if isnan(element_index)
        warning(sprintf('The node (%f,%f) is not in the given triangulation',v(i,2),v(i,3)))
        u(i) = NaN;
    else
        ee = elements(1:3,element_index);
        u(i) = v(i,2)*uvertex(ee(1))+v(i,3)*uvertex(ee(2))+v(i,4)*uvertex(ee(3));
    end
end

return